import numpy as np
import matplotlib.pyplot as plt

data = np.loadtxt("data.txt").T
data[1] = data[1]/data[0]
data[2] = data[2]/data[0]
data_cols = data
data = data.T

ANIMATION_TIME = 0.02

plt.axis([0, 10, 0, 1])
plt.ion()

min_x = min(data_cols[1])
max_x = max(data_cols[1])
min_y = min(data_cols[2])
max_y = max(data_cols[2])

buckets = [(20000*n, 20000*n+2000000) for n in range(350)]

for i in range(50):
    plt.pause(ANIMATION_TIME)

def render_bucket(k):
    x = []
    y = []
    for row in data:
        if row[0] >= buckets[k][0] and row[0] < buckets[k][1]:
        # if (np.random.random_integers(0,10) < 5):
            x.append(row[1])
            y.append(row[2])
    plt.scatter(x, y)
    plt.plot(np.unique(x), np.poly1d(np.polyfit(x, y, 1))(np.unique(x)))
    plt.xlabel('Death Rates')
    plt.xlim([min_x, max_x])
    plt.ylabel('Birth Rates')
    plt.ylim([min_y, max_y])
    plt.title('Birth Rates vs. Death Rates for Population in Range ['+"{:,}".format(buckets[k][0])+', '+"{:,}".format(buckets[k][1])+']')

for k in range(len(buckets)-1):
    render_bucket(k)
    plt.pause(ANIMATION_TIME)
    plt.clf()

render_bucket(len(buckets)-1)
while True:
    plt.pause(ANIMATION_TIME)

# import matplotlib.pyplot as plt
# import numpy as np
# import matplotlib.animation as animation

# def main():
#     numframes = 5
#     numpoints = 10
#     color_data = np.random.random((numframes, numpoints))
#     print(color_data)[0]
#     x, y, c = np.random.random((3, numpoints))

#     fig = plt.figure()
#     scat = plt.scatter(x, y, c=c, s=100)

#     ani = animation.FuncAnimation(fig, update_plot, frames=xrange(numframes),
#                                   fargs=(color_data, scat))
#     plt.show()

# def update_plot(i, data, scat):
#     scat.set_array(data[i])
#     return scat

# main()